'use client';
import { useState, useEffect } from 'react';
import { getAuthToken } from '@/utils/auth';
import { useDispatch, useSelector } from "react-redux";
import { fetchListAllPost, fetchDeletePost } from "@/utils/apiActions";
import "react-confirm-alert/src/react-confirm-alert.css";
import { fetchAnnouncementsAction, deleteAnnouncementAction, likeAnnouncementAction, updateCommentCountAction } from "@/store/slices/announcementsSlice";
import { confirmAlert } from "react-confirm-alert";
import "react-confirm-alert/src/react-confirm-alert.css";
import MyPostItem from './singlecomp';
import moment from "moment";

const MyPostPage = () => {
    const [loading, setLoading] = useState(true);
    const token = getAuthToken();
    const announcementListObj = useSelector(state => state.announcements);
    const allPost = announcementListObj.announcementsData;    
    const [openDropdowns, setOpenDropdowns] = useState({});
    const dispatch=useDispatch();
    const userObj = useSelector(state => state.user);
    const currentUser = userObj.user;
    const [isMounted, setIsMounted] = useState(false);

    // Format date to short time format
    moment.updateLocale('en', {
        relativeTime: {
          future: 'in %s',
          past: '%s ago',
          s: 'a few seconds',
          ss: '%d seconds',
          m: 'a minute',
          mm: '%d minutes',
          h: 'an hour',
          hh: '%d hours',
          d: '%d day',
          dd: '%d days',
          M: '%d month',
          MM: '%d months',
          y: '%d year',
          yy: '%d years',
        },
    });

    // Fetch all posts
    const getAllAnnouncements = async() =>{
        setLoading(true);
        const [announcementsData] = await Promise.all([fetchListAllPost()]);

        if (announcementsData.status === 1) {
            dispatch(fetchAnnouncementsAction(announcementsData.data));            
        }
        else{
            console.log(announcementsData.message);
        }
        setLoading(false);
    }

    useEffect(() => {
        if (!isMounted) {
            setIsMounted(true);
            return;
        }
        getAllAnnouncements();
    }, [isMounted]);

    // Delete post
    const handleDeletePost = async (postId) => {
        try {
            await fetchDeletePost(postId);
            setAllPost((prevPosts) => prevPosts.filter((post) => post.id !== postId));
        } catch (error) {
            console.error("Error deleting post:", error);
        }
    };

    const deletePost = (postId) => {
        confirmAlert({
            customUI: ({ onClose }) => (
                <div className="delete-confirm-ui p-3 w-100 mx-auto">
                    <div className="fs-5 fw-bold border-bottom border-grey pb-2 mb-2 text-center">
                        Are you sure?
                    </div>
                    <p className="fs-6 mb-4 pb-4 text-center">
                        Are you sure you want to delete this post?
                    </p>
                    <div className="d-flex justify-content-end gap-3 border-top border-gray pt-3">
                        <button className="btn btn-primary btn-sm" onClick={() => { handleDeletePost(postId); onClose(); }} >
                            Yes
                        </button>
                        <button className="btn btn-outline-primary btn-sm" onClick={onClose}>
                            No
                        </button>
                    </div>
                </div>
            ),
        });
    };

    return (
        <div className='main section-padding'>
            <div className="container">
                <div className="row">
                    <div className="col-12">
                        <div className="d-flex flex-wrap justify-content-between align-items-start align-items-md-center mb-4 border-bottom border-grey pb-2">
                            <h2 className="section-title mb-2 mb-md-0">My Posts</h2>
                        </div>
                    </div>
                    {loading ? (
                        <div className="col-md-12">
                            <div className="css-loader">
                                <div className="lds-ripple"><div></div><div></div></div>
                            </div>
                        </div>
                    ) : allPost.length > 0 ? (
                        <>
                            {allPost.map((post, index) => (
                                post.is_owner === true && (
                                    <div className="col-12 col-md-4" key={post.id || index}>
                                        <MyPostItem 
                                            post={post} 
                                            refreshAnnouncements={getAllAnnouncements}
                                            currentUser={currentUser} 
                                            token={token} 
                                            dispatch={dispatch} 
                                            deleteAnnouncementAction={deleteAnnouncementAction}
                                            likeAnnouncementAction={likeAnnouncementAction}
                                            updateCommentCountAction={updateCommentCountAction}
                                        />
                                    </div>
                                )
                            ))}
                        </>                    
                    ) : (
                        <div className="col-md-12">
                            <h5 className="text-center fw-normal">No posts available at the moment, create new post now.</h5>
                        </div>
                    )}
                </div>
            </div>
        </div>
    );
};

export default MyPostPage;
