"use client";
import { Quicksand } from "next/font/google";
import { Provider } from 'react-redux';
import { useEffect } from 'react';
import { usePathname } from 'next/navigation';
import store from '@/store';
import "../../styles/bootstrap.scss";
import "../../themify-icons/themify-icons.css";
import "../../styles/scss/style.scss";
import DashboardHeader from "@/components/Header/dashboardheader";
import Footer from "@/components/Footer/footer";

const quicksand = Quicksand({ 
  weight: ['500', '600', '700'],
  subsets: ["latin"], 
  display: 'swap', 
  variable:'--font-quicksand' 
});

export default function ProviderLayout({ children }) {
  const pathname = usePathname();

  useEffect(() => {
    const body = document.body;
    const bodyClass = pathname.replace(/\//g, "-").replace(/^-/, "") || "home";
    body.classList.add("dashboard", bodyClass);
    return () => {
      body.classList.remove(bodyClass);
    };
  }, [pathname]);

  return (
    <Provider store={store}>
      <html lang="en">
        <head>
          <meta name="robots" content="noindex, nofollow" />
          <title>Dashboard: During Those Time</title>
          <meta name="keywords" content="Home" />
          <meta name="description" content="During Those Times was created to allow users like you and me to have a more exclusive social network dedicated to family, close friends, and those we love." />
          <meta property="og:title" content="During Those Times" />
          <meta property="og:description" content="During Those Times was created to allow users like you and me to have a more exclusive social network dedicated to family, close friends, and those we love." />
          <meta property="og:type" content="https://duringthosetimes.com/" />
          <meta property="og:image" content="https://duringthosetimes.com/images/logo.png" />
          {/* <script type="text/javascript" src="https://www.bugherd.com/sidebarv2.js?apikey=zf3ol8563feckta4khpjvq" async="true"></script> */}
        </head>
        <body className={`dashboard ${quicksand.variable}`}>
          <DashboardHeader />
          {children}
          <Footer />
        </body>
      </html>
    </Provider>
  );
}
