"use client";

import React, { useEffect, useRef, useState } from "react";
import f3 from "family-chart";
import "family-chart/styles/family-chart.css";
import './treelife.scss';
import Cookies from 'js-cookie';

const FamilyTree = () => {
  const cont = useRef(null);
  const [treeData, setTreeData] = useState([]);  
  const [savedData, setSavedData] = useState(null);  
  useEffect(() => {
    if (typeof window === "undefined" || !cont.current) return;
    const storedData = Cookies.get("familyTreeData");
    const parsedData = storedData ? JSON.parse(storedData) : data();  
    setTreeData(parsedData);    
    setSavedData(parsedData);
    cont.current.innerHTML = "";
    createChart(parsedData);  
    document.querySelectorAll(".card-main").forEach(el => {
      el.classList.add("main-card");
    });
  }, []);  

  const createChart = (data) => {
    const f3Chart = f3.createChart(cont.current, data)
      .setTransitionTime(1000)
      .setCardXSpacing(250)
      .setCardYSpacing(150)
      .setOrientationVertical()
      .setSingleParentEmptyCard(true, { label: "ADD" });
      const f3Card = f3Chart.setCard(f3.CardHtml)
      .setCardDisplay([["first name", "last name"], ["relationship"]])
      .setMiniTree(true)
      .setStyle("imageRect")
      .setOnHoverPathToMain();
      const f3EditTree = f3Chart.editTree()
      .fixed(true)
      .setFields(["first name", "last name", "relationship"])

      .setEditFirst(true);

    f3EditTree.getDataJson = f3SubmitCallback;
    
    function f3SubmitCallback(datum) {
      console.log(datum);
    }

    f3EditTree.setEdit();

    f3Card.setOnCardClick((e, d) => {
      f3EditTree.open(d);
      if (f3EditTree.isAddingRelative()) return;
      f3Card.onCardClickDefault(e, d);
    });

    f3Chart.updateTree({ initial: true });
    f3EditTree.open(f3Chart.getMainDatum());
    f3Chart.updateTree({ initial: true });
  };
  const data = () => [
    {
      id: "0",
      rels: {},
      data: {
        "first name": "Me",
        "last name": "",
      }
    }
  ];
  
  const handleSave = () => {
    Cookies.set("familyTreeData", JSON.stringify(treeData), { expires: 7 });
    alert("Family tree data saved");
    setSavedData(treeData);
    window.location.reload();
  };
  return (
    <div>
      <div className="text-end">
        <button onClick={handleSave} className="btn py-0 px-0 text-decoration-none text-white btn-primary px-2 py-1 mt-2 mb-3 fw-semibold">Save Tree Data</button>
      </div>
      <div className="f3 f3-cont" id="FamilyChart" ref={cont}></div>
      <div className="text-end">
        <button onClick={handleSave} className="btn py-0 px-0 text-decoration-none text-white btn-primary px-2 py-1 mt-3 mb-3 fw-semibold">Save Tree Data</button>
      </div>
    </div>
  );
};

export default FamilyTree;
