'use client';
import { useEffect, useState, useCallback } from 'react';
import { useSelector } from "react-redux";
import BoxCardStyleOne from "@/components/BoxCards/BoxCardStyleOne";
import Link from 'next/link';
import SendMessage from "@/components/Popups/SendMessage";
import { fetchStatistics } from "@/utils/apiActions";

const FriendsFamilyPage = () => {
    const userObj = useSelector(state => state.user);
    const currentUser = userObj.user;
    const [showSendMessage, setShowSendMessage] = useState(false);
    const [triggerRender, setTriggerRender] = useState(false);
    const [statisticData, setStatisticData] = useState([]);    

    useEffect(() => {
        if (Object.keys(currentUser).length > 0 && !currentUser.subscription_status) {
            window.location.href = "/dashboard/subscriptionplan";
        }
    }, [currentUser]);

    const handleOpenModal = useCallback(() => {
        setShowSendMessage(true);
        setTriggerRender(prev => !prev);
    }, []);

    const handleCloseModal = useCallback(() => {
        setShowSendMessage(false);
        setTriggerRender(prev => !prev);
    }, []);

    const getStatistics = async () => {
        try {
            const [statisticData] = await Promise.all([fetchStatistics()]);
            setStatisticData(statisticData.data);
        } catch (error) {
            console.error("Error fetching statistics:", error);
        }
    };
    useEffect(() => {
        getStatistics();
    }, []);

    return (
        <div className="has-colored-text row justify-content-center">
            <div className="col-md-5 col-sm-6 mb-30">
                <Link href={'/dashboard/friends-family/my-connections/invitations'} className='text-dark text-decoration-none'>
                <BoxCardStyleOne
                    title="Invitations"
                    text={
                        <>
                          You currently have <b>({statisticData.total_pending_requests})</b> pending invitation(s). Send invitations to connect with more Family and Friends!
                        </>
                    }
                    iconClass="ti-share"/>
                </Link>
            </div>

            <div className="col-md-5 col-sm-6 mb-30">
                <button onClick={handleOpenModal} className='border-0 shadow-none p-0 text-start'>
                    <BoxCardStyleOne
                        title="Send a Message"
                        text={
                            <>
                              You have <b>(0)</b> new messages. Send a direct message to your loved ones.
                            </>
                          }
                        iconClass="ti-comment" />
                </button>
            </div>

            {showSendMessage && (
                <SendMessage key={triggerRender} onClose={handleCloseModal} />
            )}

            <div className="col-md-5 col-sm-6 mb-30">
                <Link href={'/dashboard'} className='text-dark text-decoration-none'>
                    <BoxCardStyleOne
                        title="Make an announcement"
                        text="Create a post for all of your connections to see and love!"
                        iconClass="ti-announcement" />
                </Link>
            </div>

            <div className="col-md-5 col-sm-6 mb-30">
                <Link href={'/dashboard/events'} className='text-dark text-decoration-none'>
                    <BoxCardStyleOne
                        title="Share An Event"
                        text={
                            <>
                              You have <b>({statisticData.total_events})</b> events today. Create a new event and share with a family member or friend.
                            </>
                        }
                        iconClass="ti-calendar" />
                </Link>
            </div>
        </div>
    );
}

export default FriendsFamilyPage;
