'use client';

import { useEffect, useState } from "react";
import { usePathname } from "next/navigation";
import { useSelector } from "react-redux";
import { fetchConnections } from "@/utils/apiActions";
import ReactPaginate from "react-paginate";
import Link from "next/link";
import MyConnection from "@/components/Cards/MyConnection";
import { getAuthToken } from "@/utils/auth";
import SendInvitation from "@/components/Popups/SendInvitation";

const MyConnectionsPage=()=>{
    const [loading, setLoading] = useState(false);
    const [isMounted, setIsMounted] = useState(false);
    const [myConnections, setMyConnections] = useState([]);
    const [showInvitePopup,setShowInvitePopup] = useState(false);
    const [pageOffset, setPageOffset] = useState(0);
    const [pageCount, setPageCount] = useState(0);
    const perPage = 10;
    const token = getAuthToken();
    const userObj = useSelector(state => state.user);
    const currentUser = userObj.user;

    const pathname = usePathname();
    const internalMenu=[
        { name: 'Get Started', href: '/dashboard/friends-family' },
        { name: 'My Connections', href: '/dashboard/friends-family/my-connections' },
        { name: 'Tree Of Life', href: '#' },
        { name: 'Keepsakes', href: '/dashboard/friends-family/keepsakes' }
    ];
    
    const isActive = (href) => {
        if (href === '/dashboard/friends-family') {
            return pathname === href; // Only match exact path
        }
        
        return pathname === href || pathname.startsWith(href);
    };

    const getMyConnections=async()=>{
        setLoading(true);
        const [connectionData] = await Promise.all([
            fetchConnections(pageOffset+1,perPage),
        ]);

        if(connectionData.status===1){
            setMyConnections(connectionData.data);
            setPageCount(connectionData.pagination.last_page);
        }
        else{
            setMyConnections([]);
        }
        setLoading(false);
    }

    useEffect(()=>{
        if(!isMounted){
            setIsMounted(true);
            return;
        }
        getMyConnections();

        if(Object.keys(currentUser).length > 0){
            if(!currentUser.subscription_status){
                window.location.href = "/dashboard/subscriptionplan";
            }
        }
    },[isMounted, currentUser]);

    return(
        <>
            <div className="d-flex flex-wrap flex-md-nowrap justify-content-between align-items-center gap-2 mb-4 border-bottom border-gray pb-2">
                <h2 className="section-title mb-0">My Connections</h2>
                <div className="d-flex justify-content-end gap-2 data-action-bar">
                    <button type="button" className="data-action-cta data-action-cta-text shadow-sm" onClick={()=>{setShowInvitePopup(!showInvitePopup);}}>Send Invitation</button>
                    <Link href={'/dashboard/friends-family/my-connections/invitations'} className="data-action-cta data-action-cta-text shadow-sm">Invitations</Link>
                </div>
            </div>
            <div className="row my-connections position-relative">
                <div className="col-12">
                    {(!loading && myConnections.length>0) ?
                        <>
                            <div className="row">
                                {myConnections.map((mc)=>(
                                    <div key={mc.id} className="col-12 col-lg-6 mb-4">
                                        <MyConnection connection={mc} getMyConnections={getMyConnections} token={token} />
                                    </div>
                                ))}
                            </div>
                        </>
                        :
                        <>
                            <p>No Conenctions Found</p>
                        </>
                    }
                </div>
                {pageCount > 1 &&
                    <div className="pt-4">
                        <ReactPaginate
                            previousLabel="<"
                            nextLabel=">"
                            pageClassName="page-item"
                            pageLinkClassName="page-link"
                            previousClassName="page-item"
                            previousLinkClassName="page-link"
                            nextClassName="page-item"
                            nextLinkClassName="page-link"
                            breakLabel="..."
                            breakClassName="page-item"
                            breakLinkClassName="page-link"
                            pageCount={pageCount}
                            activeLinkClassName=""
                            disabledLinkClassName="bg-light"
                            marginPagesDisplayed={2}
                            pageRangeDisplayed={5}
                            onPageChange={handlePageChange}
                            containerClassName="pagination d-flex"
                            activeClassName="active"
                            forcePage={pageOffset}
                        />
                    </div>
                }
                {loading &&
                <>
                    <div className="css-loader position-absolute w-100 h-100 top-0 left-0">
                        <div className="lds-ripple"><div></div><div></div></div>
                    </div>
                </>
                }
            </div>
            {showInvitePopup &&
                <SendInvitation setShowPopup={setShowInvitePopup} />
            }
        </>
    )
}

export default MyConnectionsPage;