'use client';

import { useEffect, useState } from "react";
import { usePathname } from "next/navigation";
import { fetchPendingRequest, fetchPendingSentRequest } from "@/utils/apiActions";
import Link from "next/link";
import { getAuthToken } from "@/utils/auth";
import SendInvitation from "@/components/Popups/SendInvitation";
import RequestCard from "@/components/Cards/RequestCard";

const InvitationsPage=()=>{
    const [loading, setLoading] = useState(false);
    const [isMounted, setIsMounted] = useState(false);
    const [pendingRequests, setPendingRequests] = useState([]);
    const [pendingSentRequests, setPendingSentRequests] = useState([]);
    const [showInvitePopup,setShowInvitePopup] = useState(false);
    const [pageOffset, setPageOffset] = useState(0);
    const [pageCount, setPageCount] = useState(0);
    const perPage = 10;
    const token = getAuthToken();

    const pathname = usePathname();
    const internalMenu=[
        { name: 'Get Started', href: '/dashboard/friends-family' },
        { name: 'My Connections', href: '/dashboard/friends-family/my-connections' },
        { name: 'Tree Of Life', href: '#' },
        { name: 'Keepsakes', href: '/dashboard/friends-family/keepsakes' }
    ];
    
    const isActive = (href) => {
        if (href === '/dashboard/friends-family') {
            return pathname === href; // Only match exact path
        }
        
        return pathname === href || pathname.startsWith(href);
    };

    const getMyInvitations=async()=>{
        setLoading(true);
        const [pendingReqData, pendingSentReqData] = await Promise.all([
            fetchPendingRequest(),
            fetchPendingSentRequest(),
        ]);

        if(pendingReqData.status===1){
            setPendingRequests(pendingReqData.data);
        }
        else{
            setPendingRequests([]);
        }

        if(pendingSentReqData.status===1){
            setPendingSentRequests(pendingSentReqData.data);
        }
        else{
            setPendingSentRequests([]);
        }
        setLoading(false);
    }

    useEffect(()=>{
        if(!isMounted){
            setIsMounted(true);
            return;
        }
        getMyInvitations();
    },[isMounted]);

    return(
        <>
            <div className="d-flex flex-wrap flex-md-nowrap justify-content-between align-items-center gap-2 mb-4 border-bottom border-gray pb-2">
                <h2 className="section-title mb-0">Invitations</h2>
                <div className="d-flex justify-content-end gap-2 data-action-bar">
                    <button type="button" className="data-action-cta data-action-cta-text shadow-sm" onClick={()=>{setShowInvitePopup(!showInvitePopup);}}>Send Invitation</button>
                    <Link href={'/dashboard/friends-family/my-connections'} className="data-action-cta data-action-cta-text shadow-sm">My Connections</Link>
                </div>
            </div>
            <div className="row my-connections position-relative">
                <div className="col-12">
                    <h6 className="mb-2 text-primary">Pending Requests</h6>
                    {pendingRequests.length>0 ?
                    <>                                
                        <p className="mb-2">Following Invitations are pending to accept. Either accept or decline request.</p>
                        <div className="mb-4 row border-bottom border-gray pb-2">
                        {pendingRequests.map((ps)=>(
                            <div key={ps.id} className="col-12 col-lg-6 mb-4">
                                <RequestCard request={ps} getMyInvitations={getMyInvitations} token={token} type={'invitation'} />
                            </div>
                        ))}
                        </div>
                    </>
                    :
                    <>
                        <p className="mb-4 border-bottom border-gray pb-2">No pending available.</p>
                    </>
                    }

                    <h6 className="mb-2 text-primary">Sent Requests</h6>
                    {pendingSentRequests.length>0 ?
                    <>
                        
                        <p className="mb-2">Following Sent Requests are still pending from members.</p>
                        <div className="mb-4 row">
                        {pendingSentRequests.map((psr)=>(
                            <div key={psr.id} className="col-12 col-lg-6 mb-4">
                                <RequestCard request={psr} getMyInvitations={getMyInvitations} token={token} type={'request'} />
                            </div>
                        ))}
                        </div>
                    </>
                    :
                    <>
                        <p className="mb-4 border-bottom border-gray pb-2">No pending sent request available.</p>
                    </>
                    }
                </div>
                {loading &&
                <>
                    <div className="css-loader position-absolute w-100 h-100 top-0 left-0">
                        <div className="lds-ripple"><div></div><div></div></div>
                    </div>
                </>
                }
            </div>
            {showInvitePopup &&
                <SendInvitation setShowPopup={setShowInvitePopup} />
            }
        </>
    )
}

export default InvitationsPage;