'use client';

import { usePathname } from "next/navigation";
import Link from "next/link";

const FriendsFamilyLayout=({children})=>{
    const pathname = usePathname();
    const internalMenu=[
        { name: 'Get Started', href: '/dashboard/friends-family' },
        { name: 'My Connections', href: '/dashboard/friends-family/my-connections' },
        // { name: 'Tree Of Life', href: '/dashboard/friends-family/tree-of-life' },
        { name: 'Keepsakes', href: '/dashboard/friends-family/keepsakes' }
    ];
    
    const isActive = (href) => {
        if (href === '/dashboard/friends-family') {
            return pathname === href; // Only match exact path
        }
        
        return pathname === href || pathname.startsWith(href);
    };

    return(
        <div className="main">
            <section className="section-padding pt-100 horizontal-accordion">
                <div className="container">
                    <div className="row">
                        <div className="col-12 mb-40">
                            <h1 className="section-title">Fridends & Family</h1>
                        </div>
                    </div>
                    <div className="row justify-content-center">
                        <div className="col-12">
                            <ul className="inner-menu">
                                {internalMenu.map((item,index) => (
                                    <li key={index}>
                                        <Link className={`inner-menu-link ${isActive(item.href) ? 'active' : ''}`} href={item.href}>{item.name}</Link>
                                    </li>
                                ))}
                            </ul>
                        </div>
                    </div>                    
                    {children}
                </div>                
            </section>
        </div>
    )
}

export default FriendsFamilyLayout;