'use client';
import { useState, useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import ReactPaginate from "react-paginate";
import { fetchEventSharedAll } from "@/utils/apiActions";
import EventCard from "@/components/Cards/EventCard";
import { fetchSharedEventsAction } from "@/store/slices/sharedEventsSlice";
import Link from "next/link";
import { getAuthToken } from "@/utils/auth";

const ShardEventPage=()=>{
    const [loading, setLoading] = useState(false);
    //const [eventsList, setEventsList] = useState([]);
    const eventsListObj = useSelector(state=>state.sharedevents);
    const eventsList = eventsListObj.sharedeventsData;
    const [pageOffset, setPageOffset] = useState(0);
    const [pageCount, setPageCount] = useState(0);
    const [selectedCategory, setSelectedCategory] = useState('all');
    const perPage = 10;
    const dispatch = useDispatch();
    const token=getAuthToken();
    const [isMounted, setIsMounted] = useState(false);

    const getEvents=async()=>{
        setLoading(true);
        const [eventsData] = await Promise.all([
            fetchEventSharedAll(selectedCategory,pageOffset+1,perPage),
        ]);

        if(eventsData.status===1){
            dispatch(fetchSharedEventsAction(eventsData.data));
            //setEventsList(eventsData.data);
            setPageCount(eventsData.pagination.last_page);
        }
        setLoading(false);
    }

    const handlePageChange = (event) => {
        setPageOffset(event.selected);
    }

    const userObj = useSelector(state => state.user);
    const currentUser = userObj.user;
    useEffect(()=>{
        if (!isMounted) {
            setIsMounted(true); // Mark as mounted
            return; // Don't run the effect if it's the initial render
        }
        getEvents();

        if(Object.keys(currentUser).length > 0){
            if(!currentUser.subscription_status){
                window.location.href = "/dashboard/subscriptionplan";
            }
        }
    },[isMounted, pageOffset, perPage, currentUser]);
    
    return(
        <>
        <div className="d-flex justify-content-between align-items-start align-items-md-center mb-4 border-bottom border-grey pb-2">
            <div className="col-auto">
                <h2 className="section-title mb-0">Shared Events</h2>
            </div>
            <div className="col-auto data-action-bar">
                <Link href={'/dashboard/events'} type="button" className="data-action-cta data-action-cta-text shadow-sm">My Events</Link>
            </div>
        </div>
        <div className="position-relative">
            <div className="row justify-content-start">
                {eventsList.length>0 ?
                <>
                {eventsList.map((item)=>{
                    return(
                        <div className="col-md-6 mb-4" key={item.id}>
                            <EventCard eventItem={item} dispatch={dispatch} getEvents={getEvents} token={token} isShared={true} />
                        </div>
                    )
                })}                        
                </>
                :
                <>
                    {!loading &&
                        <p>Events not found.</p>
                    }
                </>
                }
            </div>                        
            {pageCount > 1 &&
                <div className="pt-4">
                    <ReactPaginate
                        previousLabel="<"
                        nextLabel=">"
                        pageClassName="page-item"
                        pageLinkClassName="page-link"
                        previousClassName="page-item"
                        previousLinkClassName="page-link"
                        nextClassName="page-item"
                        nextLinkClassName="page-link"
                        breakLabel="..."
                        breakClassName="page-item"
                        breakLinkClassName="page-link"
                        pageCount={pageCount}
                        activeLinkClassName=""
                        disabledLinkClassName="bg-light"
                        marginPagesDisplayed={2}
                        pageRangeDisplayed={5}
                        onPageChange={handlePageChange}
                        containerClassName="pagination d-flex"
                        activeClassName="active"
                        forcePage={pageOffset}
                    />
                </div>
            }
            {loading &&
            <>
                <div className="css-loader position-absolute w-100 h-100 top-0 left-0">
                    <div className="lds-ripple"><div></div><div></div></div>
                </div>
            </>
            }
        </div>
        </>
    )
}

export default ShardEventPage;