'use client';
import { useEffect } from 'react';
import { useSelector } from "react-redux";
import EventForm from "@/components/EventForm/EventForm";

const CreateEventPage=()=>{
    const userObj = useSelector(state => state.user);
    const currentUser = userObj.user;
    useEffect(()=>{
        if(Object.keys(currentUser).length > 0){
            if(!currentUser.subscription_status){
                window.location.href = "/dashboard/subscriptionplan";
            }
        }
    },[currentUser]);
    
    return(
        <>
            <div className="d-flex justify-content-between align-items-start align-items-md-center mb-1 mb-md-4 border-bottom border-grey pb-2">
                <div className="col-auto">
                    <h2 className="section-title mb-0">Create Event</h2>
                </div>                
            </div>
            <EventForm />
        </>
    )
}

export default CreateEventPage;