"use client"
import { Quicksand } from "next/font/google";
import "../../../styles/bootstrap.scss";
import "../../../styles/scss/style.scss";
import "../../../themify-icons/themify-icons.css";
import Header from "@/components/Header/header";
import Footer from "@/components/Footer/footer";
import { useEffect } from 'react';
import { usePathname } from 'next/navigation';
import { Provider } from "react-redux";
import store from "@/store/slices/chatSlice";

const quicksand = Quicksand({ 
  weight: ['500', '600', '700'],
  subsets: ["latin"], 
  display: 'swap', 
  variable:'--font-quicksand' });
export default function RootLayout({ children }) {
  const pathname = usePathname();

  useEffect(() => {
    const body = document.body;
    const bodyClass = pathname.replace(/\//g, "-").replace(/^-/, "") || "home";
    body.classList.add("dashboard", bodyClass);
    return () => {
      body.classList.remove(bodyClass);
    };
  }, [pathname]);
  return (
    <Provider store={store}>
    <html lang="en">
      <meta name="robots" content="noindex, nofollow" />
      <title>During Those Time</title>
      <body className={`home-page ${quicksand.variable}`}>
        <Header />
        {children}
        <Footer />
      </body>
    </html>
    </Provider>
  );
}
