"use client"
import { Quicksand } from "next/font/google";
import { Provider } from 'react-redux';
import { useEffect } from 'react';
import { usePathname } from 'next/navigation';
import store from '@/store';
import "../../styles/bootstrap.scss";
//import 'bootstrap/scss/bootstrap.scss';
import "../../themify-icons/themify-icons.css";
import "../../styles/scss/style.scss";
//import "../styles/globals.css";
import Header from "@/components/Header/header";
import Footer from "@/components/Footer/footer";
import { fetchPlans } from '@/utils/apiActions';

const quicksand = Quicksand({ 
  weight: ['500', '600', '700'],
  subsets: ["latin"], 
  display: 'swap', 
  variable:'--font-quicksand' });

export default function ProviderLayout({ children }) {
  const pathname = usePathname();

  useEffect(() => {
    const body = document.body;

    // Generate a class name based on the pathname
    const bodyClass = pathname.replace(/\//g, "-").replace(/^-/, "") || "home";

    // Add the class to the body
    body.classList.add(bodyClass);

    // Cleanup: Remove the class on route change
    return () => {
      body.classList.remove(bodyClass);
    };
  }, [pathname]);
  return (
    <Provider store={store}>
      <html lang="en">
        <head>
          <meta name="robots" content="noindex, nofollow" />
          {/* <script type="text/javascript" src="https://www.bugherd.com/sidebarv2.js?apikey=zf3ol8563feckta4khpjvq" async="true"></script> */}
          <title>Dashboard: During Those Time</title>
        </head>
        <body className={`${quicksand.variable}`}>
            <Header />
          {children}
          <Footer />
        </body>
      </html>
    </Provider>
  );
}
