const express = require('express');
const bodyParser = require('body-parser');
const stripe = require('stripe')('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');

const app = express();

app.post('/api/webhook', bodyParser.raw({ type: 'application/json' }), (req, res) => {
    const endpointSecret = 'whsec_03a47c231ce251a81b5a534b3af3e6a80f797fb9839964d7cb030e769cd03232';
    const sig = req.headers['stripe-signature'];

    let event;

    try {
        event = stripe.webhooks.constructEvent(req.body, sig, endpointSecret);
    } catch (err) {
        console.error(`Webhook signature verification failed: ${err.message}`);
        return res.status(200).send(`Webhook Error: ${err.message}`);
    }

    // Handle the event
    switch (event.type) {
        case 'checkout.session.completed':
            const session = event.data.object;
            if (session.amount_total && !isNaN(session.amount_total)) {
                console.log(`Payment was successful for session ${session.id}`);
            } else {
                console.error(`Invalid amount_total in session ${session.id}`);
            }
            break;

        case 'invoice.payment_failed':
            const invoice = event.data.object;
            if (invoice.amount_paid && !isNaN(invoice.amount_paid)) {
                console.log(`Payment failed for invoice ${invoice.id}`);
            } else {
                console.error(`Invalid amount_paid in invoice ${invoice.id}`);
            }
            break;


        default:
            console.log(`Unhandled event type ${event.type}`);
    }
    res.json({ received: true });
});

// Start the server
app.listen(4000, () => console.log('Server running on port 4000'));
