import { NextResponse } from 'next/server';

const stripe = require('stripe')('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');
// Create Checkout Session
export async function POST(request) {
    try {
        const data = await request.json();
        const customerEmail = data.email;
        const session = await stripe.checkout.sessions.create({
            success_url: 'http://newsite.duringthosetimes.com/auth/success',
            cancel_url: 'http://newsite.duringthosetimes.com/dashboard/subscriptionplan',
            line_items: [
                {
                    price_data: {
                        currency: 'USD',
                        recurring: { interval: 'month' },
                        product_data: {
                            name: data.name,
                        },
                        unit_amount: data.plan * 100,
                    },
                    quantity: 1,
                },
            ],
            mode: 'subscription',
            customer_email: customerEmail,
        });

        return NextResponse.json({ sessionId: session.id });
    } catch (error) {
        console.error('Error creating Stripe session:', error);
        return NextResponse.json({ error: error.message });
    }
}