'use client'
import {useState,useEffect} from "react";
import Image from "next/image";
import {fetchTestimonials} from '@/utils/apiActions' 

export default function Testimonialspage(){
    const [loading, setLoading] = useState(false);
    const [testimonials, setTestimonialData] = useState([]);
    const getTestimonials = async () => {
        setLoading(true);
        try {
            const testimonialData = await fetchTestimonials();
            setTestimonialData(testimonialData.data);            
        } catch (error) {
            console.error("Error fetching resources:", error);
        }
        setLoading(false);
        };
    
    useEffect(() => {
        getTestimonials();
    }, []);
    return(
        <>
        {testimonials.length > 0 &&
            <div className="main relative">
                <section className="section-padding testimonial-detail testimonials-section has-shapes">
                    <div className="container">
                        <div className="row justify-content-center">
                        <div className="col-lg-6 col-md-9 text-center ">
                            <h2 className="section-title">
                                What Our <strong>Members Say</strong>
                            </h2>
                            {/* <p>
                            Lorem ipsum sadip dolor sit amet, consetetur sadip scing elitr,
                            diam nonumy eirmod tempor invi duntut labore et dolore magna
                            aliquyam erat, sed diam
                            </p> */}
                        </div>
                        </div>
                        <div className="row">
                        <div className="col-md-12">
                            <div className="testimonials-list justify-content-center">
                                {testimonials.map((item, index)=> (
                                    <div className="testimonials-item bg-white" key={index}>
                                        <div className="block border rounded bg-white">
                                        <svg
                                            className="icon mb-15"
                                            width="25"
                                            height="20"
                                            viewBox="0 0 40 35"
                                            fill="none"
                                            xmlns="http://www.w3.org/2000/svg"
                                        >
                                            <path
                                            d="M3.75001 35L13.75 35C15.8203 35 17.5 33.3203 17.5 31.25L17.5 21.25C17.5 19.1797 15.8203 17.5 13.75 17.5L7.50001 17.5L7.50001 12.5C7.50001 9.74219 9.74219 7.5 12.5 7.5L13.125 7.5C14.1641 7.5 15 6.66406 15 5.625L15 1.875C15 0.83594 14.1641 2.25865e-06 13.125 2.34949e-06L12.5 2.40413e-06C5.59375 3.00789e-06 5.05862e-06 5.59375 5.66238e-06 12.5L7.30156e-06 31.25C7.48255e-06 33.3203 1.6797 35 3.75001 35ZM26.25 35L36.25 35C38.3203 35 40 33.3203 40 31.25L40 21.25C40 19.1797 38.3203 17.5 36.25 17.5L30 17.5L30 12.5C30 9.74219 32.2422 7.5 35 7.5L35.625 7.5C36.6641 7.5 37.5 6.66406 37.5 5.625L37.5 1.875C37.5 0.835938 36.6641 2.91637e-07 35.625 3.82475e-07L35 4.37114e-07C28.0937 1.04088e-06 22.5 5.59375 22.5 12.5L22.5 31.25C22.5 33.3203 24.1797 35 26.25 35Z"
                                            fill="currentColor"
                                            />
                                        </svg>
                                        <p className="h4 text-black-300 font-weight-light">
                                        {item.testimonial_text}
                                        </p>
                                        <Image className="absolute top-full w-8 h-4 bg-transparent" src="/images/testimonials/arrow.png" width={32} height={14} alt="" />
                                        </div>
                                        <div className="user-info d-flex align-items-center mt-30">
                                        <Image
                                            className="d-inline rounded-circle mr-3 object-fit-cover"
                                            src={item.image.original_url}
                                            width={312}
                                            height={312}
                                            alt=""
                                        />
                                        <div className="pt-1 ps-2">
                                            <h5 className="font-weight-bold">{item.name}</h5>
                                            <p>{item.profession}</p>
                                        </div>
                                        </div>
                                    </div>
                                ))}
                                
                            </div>
                        </div>
                        </div>
                    </div>

                    <div className="shape-1 shape-sm bg-secondary rounded-circle d-none d-sm-block"></div>
                    <div className="shape-2 shape-sm bg-primary rounded-circle d-none d-sm-block"></div>
                    <div className="shape-3 shape-sm bg-tertiary rounded-circle d-none d-sm-block"></div>
                    <div className="shape-4 shape-sm bg-secondary rounded-circle d-none d-sm-block"></div>
                    <div className="shape-5 shape-xs bg-primary rounded-circle d-none d-sm-block"></div>
                    <div className="shape-6 shape-xs-2 bg-tertiary rounded-circle d-none d-sm-block"></div>
                </section>
            </div>
        }
        </>
    )
}