"use client"
import { Quicksand } from "next/font/google";
import "../../styles/bootstrap.scss";
//import 'bootstrap/scss/bootstrap.scss';
import "../../styles/scss/style.scss";
import "../../themify-icons/themify-icons.css";
//import "../styles/globals.css";
import Header from "@/components/Header/header";
import Footer from "@/components/Footer/footer";
import { useEffect } from 'react';
import { usePathname } from 'next/navigation';
import Image from "next/image";

const quicksand = Quicksand({ 
  weight: ['500', '600', '700'],
  subsets: ["latin"], 
  display: 'swap', 
  variable:'--font-quicksand' });

// export const metadata = {
//   title: "During Those Time",
//   description: "Generated by During Those Time",
// };
 
export default function RootLayout({ children }) {
  const pathname = usePathname();

  useEffect(() => {
    const body = document.body;

    // Generate a class name based on the pathname
    const bodyClass = pathname.replace(/\//g, "-").replace(/^-/, "") || "home";

    // Add both the "dashboard" class and the generated class
    body.classList.add("dashboard", bodyClass);

    // Cleanup: Only remove the dynamically generated class on route change
    return () => {
      body.classList.remove(bodyClass); // Keep "dashboard" class intact
    };
  }, [pathname]);
  return (
    <html lang="en">
      <meta name="robots" content="noindex, nofollow" />
      <title>During Those Time</title>
      <meta name="keywords" content="Home" />
      <meta name="description" content="During Those Times was created to allow users like you and me to have a more exclusive social network dedicated to family, close friends, and those we love." />
      <meta property="og:title" content="During Those Times" />
      <meta property="og:description" content="During Those Times was created to allow users like you and me to have a more exclusive social network dedicated to family, close friends, and those we love." />
      <meta property="og:type" content="https://duringthosetimes.com/" />
      <meta property="og:image" content="https://duringthosetimes.com/images/logo.png" />

      {/* <script type="text/javascript" src="https://www.bugherd.com/sidebarv2.js?apikey=zf3ol8563feckta4khpjvq" async="true"></script> */}
      <body className={`home-page ${quicksand.variable}`}>
        <Header />
        {children}
        <Footer />
      </body>
    </html>
  );
}
