/** @type {import('next').NextConfig} */

const securityHeaders = [
    {
      key: 'X-Content-Type-Options',
      value: 'nosniff',
    },
    {
      key: 'Strict-Transport-Security',
      value: 'max-age=31536000; includeSubDomains; preload',
    },
    {
      key: 'Referrer-Policy',
      value: 'no-referrer-when-downgrade',
    },
    {
      key: 'Permissions-Policy',
      value: "geolocation=(self), vibrate=(self)",
    },
    {
      key: 'X-Frame-Options',
      value: 'DENY',
    },
    {
      key: 'X-XSS-Protection',
      value: '1; mode=block',
    },
];

const nextConfig = {
    async headers() {
        return [
          {
            // Apply these headers to all routes in your application.
            source: '/(.*)',
            headers: securityHeaders,
          },
        ]
    },
    images: {
      remotePatterns: [
      {
          protocol: 'https',
          hostname:"cms.duringthosetimes.com",
          port: '',
      },   
      {
        protocol: 'https',
        hostname:"dtt.theprojectpreview.com",
        port: '',
      },   
    ],
  },
};
export default nextConfig;

